/*
 * Decompiled with CFR 0.152.
 */
package com.category.domain.use_case.product_category;

import com.category.data.ProductCategoryDao;
import com.category.domain.use_case.GetSellPrices;
import com.dto.LoginDto;
import com.utility.ConvertStr;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Service;

@Service
public class GetCategoriesPerProduct {
    private final ProductCategoryDao dao;
    private final GetSellPrices getSellPrices;

    public Map<String, List<Map<String, Object>>> invoke(String sqlWhere, @Nullable String commaSeparatedACodes) {
        LoginDto login = this.dao.setToken();
        sqlWhere = this.getSqlWhereForAll(sqlWhere, commaSeparatedACodes);
        List rowSetPoshak = this.dao.getProductCategories(login, sqlWhere);
        List rowSellPrices = this.dao.getPCategorySellPrices(login, sqlWhere);
        HashMap<String, List<Map<String, Object>>> mapPoshakList = new HashMap<String, List<Map<String, Object>>>();
        for (Map poshak : rowSetPoshak) {
            String aCode = (String)poshak.get("A_code");
            this.getSellPrices.invoke(poshak, rowSellPrices);
            if (!login.getIsMyHoloo().booleanValue()) {
                poshak.put("A_code", ConvertStr.encrypt((String)aCode));
            }
            if (mapPoshakList.containsKey(aCode)) {
                ((List)mapPoshakList.get(aCode)).add(poshak);
                continue;
            }
            mapPoshakList.put(aCode, ConvertStr.singletonArrayList((Object)poshak));
        }
        return mapPoshakList;
    }

    private String getSqlWhereForAll(String sqlWhere, String commaSeperatedACodes) {
        if (commaSeperatedACodes == null) {
            return sqlWhere;
        }
        if (ConvertStr.isNullOrEmpty((String)sqlWhere)) {
            return " WHERE A.A_CODE IN (" + commaSeperatedACodes + ")";
        }
        return sqlWhere + " AND A.A_CODE IN (" + commaSeperatedACodes + ")";
    }

    public GetCategoriesPerProduct(ProductCategoryDao dao, GetSellPrices getSellPrices) {
        this.dao = dao;
        this.getSellPrices = getSellPrices;
    }
}

